####################
# ## PARAMETERS ## #
####################

config = {
  # paths for connecting to cloud storage
  "vm_path": 'ebm-life-cycle/',
  "gs_path": 'gen-tfrc-europewest4',
  "exp_name": 'imagenet_shortrun_test',
  "exp_dir": 'tfrc_out/fid',

  # device type ('tpu' or 'gpu' or 'cpu')
  "device_type": 'tpu',
  # number of gpus if using gpu device
  #'num_gpus': 1,

  # exp params
  "exp_type": "folder",
  "num_fid_rounds": 520,
  "batch_size": 96,
  "image_dims": [128, 128, 3],
  "split": "train",
  #"transform_type": "train",

  # ckpt folder
  #"ckpt_folder": 'gs://gen-tfrc-uscentral1/tfrc_out/celeb_a/nonconv_resnet_21-08-09-01-25-01',
  #"epoch_freq": 5000,
  #"min_epoch": 5000,
  #"max_epoch": 145000,

  # data type and augmentation parameters
  "data_type": 'imagenet2012',
  "random_crop": False,
 
  # ebm network
  "net_type": 'ebm_sngan',

  # langevin sampling parameters
  "mcmc_steps": 200,
  "epsilon": 3e-3,
  "mcmc_init": "coop",
  "mcmc_temp": 1e-7,
  # clipping parameters
  "max_langevin_norm": 2.0,
  "clip_langevin_grad": False,

  "gen_type": "gen_sngan",
  "z_sz": 128,
  "fixed_gen": False
}
